*--- Example of simple Data Environment Class
DEFINE CLASS DataEnv_with_DataSession as DataEnvironment
	
	*--- Reference to Private Session Object
	oSession = .NULL.
	
	*--- Add cursor object for Customer
	ADD OBJECT oCustomer AS tblCustomer
	
	PROCEDURE Init
		
		*--- Open a private Data Session
		This.oSession = CREATEOBJECT("privateSession")
		
		*--- Change to the appropriate Data Session
		SET DATASESSION TO This.oSession.DataSessionID
		
		*--- Open Tables Accordingly
		IF This.AutoOpenTables
			This.OpenTables()
		ENDIF
		
	ENDPROC
	
	PROCEDURE Destroy()
		
		*--- Close Tables Accordingly
		IF This.AutoCloseTables
			This.CloseTables()
		ENDIF
		
	ENDPROC
	
ENDDEFINE

*--- Tables for Data Environment
DEFINE CLASS tblCustomer as Cursor

	Alias = "Customer"
	CursorSource = "Customer"
	Database = "TestData.dbc"
	
ENDDEFINE

*--- Private Session Class
DEFINE CLASS privateSession as Session
	DataSession = 2 && Private Data Session
ENDDEFINE
